/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities;

import com.Da_Technomancer.essentials.gui.container.ItemShifterContainer;
import com.Da_Technomancer.essentials.tileentities.AbstractShifterTileEntity;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="essentials")
public class ItemShifterTileEntity
extends AbstractShifterTileEntity
implements Container {
    @ObjectHolder(value="item_shifter")
    public static BlockEntityType<ItemShifterTileEntity> TYPE = null;
    private ItemStack inventory = ItemStack.f_41583_;
    private LazyOptional<IItemHandler> outputOptionalCache = LazyOptional.empty();
    private LazyOptional<IItemHandler> invOptional = LazyOptional.of(() -> new InventoryHandler());

    public ItemShifterTileEntity(BlockPos pos, BlockState state) {
        super(TYPE, pos, state);
    }

    @Override
    public void serverTick() {
        BlockEntity endTE;
        if (this.endPos == null) {
            this.refreshCache();
        }
        if (this.inventory.m_41619_()) {
            return;
        }
        if (!this.outputOptionalCache.isPresent() && (endTE = this.f_58857_.m_7702_(this.endPos)) != null) {
            this.outputOptionalCache = endTE.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getFacing().m_122424_());
        }
        this.inventory = ItemShifterTileEntity.ejectItem(this.f_58857_, this.endPos, this.getFacing(), this.inventory, this.outputOptionalCache);
    }

    @Override
    public void refreshCache() {
        super.refreshCache();
        this.outputOptionalCache = LazyOptional.empty();
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        if (!this.inventory.m_41619_()) {
            nbt.m_128365_("inv", (Tag)this.inventory.m_41739_(new CompoundTag()));
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("inv")) {
            this.inventory = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("inv"));
        }
    }

    public void m_7651_() {
        super.m_7651_();
        this.invOptional.invalidate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction facing) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.invOptional;
        }
        return super.getCapability(cap, facing);
    }

    public Component m_5446_() {
        return new TranslatableComponent("container.item_shifter");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
        return new ItemShifterContainer(id, playerInventory, this);
    }

    public int m_6643_() {
        return 1;
    }

    public boolean m_7983_() {
        return this.inventory.m_41619_();
    }

    public ItemStack m_8020_(int index) {
        return index == 0 ? this.inventory : ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int index, int count) {
        this.m_6596_();
        return index == 0 ? this.inventory.m_41620_(count) : ItemStack.f_41583_;
    }

    public ItemStack m_8016_(int index) {
        if (index == 0) {
            ItemStack removed = this.inventory;
            this.inventory = ItemStack.f_41583_;
            this.m_6596_();
            return removed;
        }
        return ItemStack.f_41583_;
    }

    public void m_6836_(int index, ItemStack stack) {
        if (index == 0) {
            this.inventory = stack;
            this.m_6596_();
        }
    }

    public int m_6893_() {
        return 64;
    }

    public boolean m_6542_(Player player) {
        return this.f_58858_.m_203193_((Position)player.m_20182_()) < 64.0;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return index == 0;
    }

    public void m_6211_() {
        this.inventory = ItemStack.f_41583_;
        this.m_6596_();
    }

    private class InventoryHandler
    implements IItemHandler {
        private InventoryHandler() {
        }

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            return slot == 0 ? ItemShifterTileEntity.this.inventory : ItemStack.f_41583_;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot != 0 || stack.m_41619_() || !ItemShifterTileEntity.this.inventory.m_41619_() && (!ItemShifterTileEntity.this.inventory.m_41656_(stack) || !ItemStack.m_41658_((ItemStack)ItemShifterTileEntity.this.inventory, (ItemStack)stack))) {
                return stack;
            }
            int moved = Math.min(stack.m_41613_(), stack.m_41741_() - ItemShifterTileEntity.this.inventory.m_41613_());
            if (!simulate && moved != 0) {
                if (ItemShifterTileEntity.this.inventory.m_41619_()) {
                    ItemShifterTileEntity.this.inventory = stack.m_41777_();
                    ItemShifterTileEntity.this.inventory.m_41764_(moved);
                } else {
                    ItemShifterTileEntity.this.inventory.m_41769_(moved);
                }
                ItemShifterTileEntity.this.m_6596_();
            }
            ItemStack remain = stack.m_41777_();
            remain.m_41774_(moved);
            return remain;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot != 0 || ItemShifterTileEntity.this.inventory.m_41619_() || amount <= 0) {
                return ItemStack.f_41583_;
            }
            ItemStack removed = ItemShifterTileEntity.this.inventory.m_41777_();
            removed.m_41764_(Math.min(ItemShifterTileEntity.this.inventory.m_41613_(), amount));
            if (!simulate) {
                ItemShifterTileEntity.this.inventory.m_41774_(removed.m_41613_());
                ItemShifterTileEntity.this.m_6596_();
            }
            return removed;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }
    }
}

